IF EXISTS ( SELECT * 
            FROM   sysobjects 
            WHERE  id = object_id(N'dbo.CPJ_Productos_Cobros') 
                   and OBJECTPROPERTY(id, N'IsProcedure') = 1 )
BEGIN
    DROP PROCEDURE dbo.CPJ_Productos_Cobros
END
GO

CREATE PROCEDURE [dbo].[CPJ_Productos_Cobros] @pJsonRecibido VARCHAR(8000)
AS 
SET NOCOUNT ON
/*Parametros*/
-- actualizacion lunes 17/7

DECLARE		@pId_Usuario			INT,
			@pFlagUsarTrans			TINYINT,
			@pModoDebug				TINYINT,
			@pFechaDesde			DATETIME,
			@pFechaHasta			DATETIME,
		    @pFlag_Liquidacion		TINYINT,
		    @pId_Periodo_Caja		INT,
		    @pFlag_FPago			TINYINT,
		    @pTipo_Cob				CHAR(1),		-- vacio = todos  M = Manual L=Lote
			@pFormato				VARCHAR(3),     --D  Detallado   F Resumen por Familia     CF  Resumen por Cobrador Familia  CFM  Resumen por Cob,Familia,Mes  P Producto  T Tipo/Categoria    CTA  Por cuenta y CC
			@pFlag_Filtrar_Fam		TINYINT,
			@pFlag_Inc_Fact_Periodo	TINYINT,		--Incluye lo facturado en el periodo y no este cobrado solo para formato  D
			@pFlag_Filtrar_Prod		TINYINT,
			@pFlag_No_Rec_Aplic		TINYINT,		-- Se agrega flag para validar si no se requiere Recibos de Aplicacion- 2021/08/12  0=Con Recibos de Aplica, 1= Sin Recibos de Aplica
			@pFlag_Filtrar_CC		TINYINT,
			@pId_Centro_Costo		VARCHAR(10),
            @pFlag_Filtrar_Caja		TINYINT,
			@pRegenerar_Archivo		CHAR(1)
			


SET @pId_Usuario				= ISNULL(CONVERT(SMALLINT, dbo.CF_JSON_VALUE(@pJsonRecibido,'Id_Usuario')), 0)
SET @pFlagUsarTrans				= ISNULL(CONVERT(TINYINT, dbo.CF_JSON_VALUE(@pJsonRecibido,'FlagUsarTrans')), 0)
SET @pModoDebug					= ISNULL(CONVERT(TINYINT, dbo.CF_JSON_VALUE(@pJsonRecibido,'ModoDebug')), 0)

SET @pFechaDesde				= ISNULL(CONVERT(DATETIME, dbo.CF_JSON_VALUE(@pJsonRecibido,'FechaDesde')),GETDATE())
SET @pFechaHasta				= ISNULL(CONVERT(DATETIME, dbo.CF_JSON_VALUE(@pJsonRecibido,'FechaHasta')),GETDATE())

SET	@pFlag_Liquidacion			= ISNULL(CONVERT(TINYINT, dbo.CF_JSON_VALUE(@pJsonRecibido,'Flag_Liquidacion')), 0)
SET	@pId_Periodo_Caja			= ISNULL(CONVERT(INT, dbo.CF_JSON_VALUE(@pJsonRecibido,'Id_Periodo_Caja')), 0)
SET	@pFlag_FPago				= ISNULL(CONVERT(TINYINT, dbo.CF_JSON_VALUE(@pJsonRecibido,'Flag_FPago')), 0)
SET	@pTipo_Cob					= ISNULL(CONVERT(CHAR(1), dbo.CF_JSON_VALUE(@pJsonRecibido,'Tipo_Cob')), '')
SET	@pFormato					= ISNULL(CONVERT(VARCHAR(3), dbo.CF_JSON_VALUE(@pJsonRecibido,'Formato')), 0)
SET	@pFlag_Filtrar_Fam			= ISNULL(CONVERT(TINYINT, dbo.CF_JSON_VALUE(@pJsonRecibido,'Flag_Filtrar_Fam')), 0)
SET	@pFlag_Inc_Fact_Periodo		= ISNULL(CONVERT(TINYINT, dbo.CF_JSON_VALUE(@pJsonRecibido,'Flag_Inc_Fact_Periodo')), 0)
SET	@pFlag_Filtrar_Prod			= ISNULL(CONVERT(TINYINT, dbo.CF_JSON_VALUE(@pJsonRecibido,'Flag_Filtrar_Prod')), 0)
SET @pFlag_No_Rec_Aplic			= ISNULL(CONVERT(TINYINT, dbo.CF_JSON_VALUE(@pJsonRecibido,'Flag_No_Rec_Aplic')), 0)
SET @pFlag_Filtrar_CC			= ISNULL(CONVERT(TINYINT, dbo.CF_JSON_VALUE(@pJsonRecibido,'Flag_Filtrar_CC')), 0)
SET @pId_Centro_Costo	        = ISNULL(CONVERT(VARCHAR(10), dbo.CF_JSON_VALUE(@pJsonRecibido,'Id_Centro_Costo')), '')
SET @pFlag_Filtrar_Caja			= ISNULL(CONVERT(TINYINT, dbo.CF_JSON_VALUE(@pJsonRecibido,'Flag_Filtrar_Caja')), 0)
SET @pRegenerar_Archivo			= ISNULL(CONVERT(CHAR(1), dbo.CF_JSON_VALUE(@pJsonRecibido,'Regenerar_Archivo')),'S')


  CREATE TABLE #Trans (Id_Trans INT)

  CREATE TABLE #Coef_Pagos (Id_Trans Int
	,Imp_Total_Rec decimal(14,2)
	,Imp_Valores decimal(14,2)
	,Imp_PAGOS_APLI decimal(14,2)
	,Imp_Efe decimal(14,2)
	,Imp_Tar decimal(14,2)
	,Imp_CH3 decimal(14,2) 
	,Imp_CHP decimal(14,2)
	,Imp_DB decimal(14,2)
	,Imp_Fin decimal(14,2)
	,Imp_Aju decimal(14,2)
	,Coef_PAGOS_APLI decimal(14,5)
	,Coef_Efe decimal(14,5)
	,Coef_Tar decimal(14,5)
	,Coef_CH3 decimal(14,5) 
	,Coef_CHP decimal(14,5)
	,Coef_DB decimal(14,5)
	,Coef_Fin decimal(14,5)
	,Coef_Aju decimal(14,5)
	)

  DECLARE @Id_Producto 				VARCHAR(14)
		  ,@Id_Proveedor 			INT
		  ,@Razon_Social		 	VARCHAR(100)
		  ,@Cuit 					VARCHAR(13)
		  ,@Id_Iva 					CHAR(3)
		  ,@Id_Alias_Cta_Cont 		INT
		  ,@Id_Cta_Contable_H 		INT
		  ,@Porc_Comision_Prov 		DECIMAL(7,2) 
		  ,@Importe 				DECIMAL(12,2) 
		  ,@Importe_Credito 		DECIMAL(12,2) 
		  ,@Id_Tipo_Cbte 			CHAR(4) 
		  ,@Fecha 					DATETIME
		  ,@Imp_Prod_SIva  			DECIMAL(12,2) 
		  ,@Id_Trans 				INT
		  ,@Id_Cliente_Externo 		VARCHAR(14)
		  ,@Id_Cta_Banco 			INT
		  ,@Id_Cliente 				INT
		  ,@Total     				DECIMAL(20,2)
		  ,@Existe_Tag_Prod 		INT
		  ,@Existe_Tag_Fam 			INT
		  ,@Existe_Tag_Caja  		INT
		  ,@e_Tag_Prod				SMALLINT
		  ,@e_Tag_Prod_Familias		SMALLINT
		  ,@e_Tag_Prod_Cajas		SMALLINT

   DECLARE @Id_Trans_Rec INT 
		  ,@Id_Tipo_Val CHAR(3) 
		  ,@IMPORTE_Val DECIMAL(14,2)
		  ,@EXISTE SMALLINT
		  ,@Imp_Total_Rec DECIMAL(14,2)
		  ,@Tipo_val char(3)
		  ,@coef DECIMAL(10,5)
		  ,@coef_Apl DECIMAL(10,5)
		  ,@coef_Val DECIMAL(10,5)
		  ,@UltError SMALLINT

  SET @Fecha = (SELECT CAST(GETDATE() AS DATE))

  DECLARE @Sql		    VARCHAR(MAX)
  DECLARE @SqlSaldo	    VARCHAR(MAX)
  DECLARE @SqlSelect	VARCHAR(MAX)
  DECLARE @SqlInto	    VARCHAR(MAX)
  DECLARE @SqlFrom	    VARCHAR(MAX)
  DECLARE @SqlWhere  	VARCHAR(MAX)
  DECLARE @SqlGroup	    VARCHAR(MAX)

  SET @e_Tag_Prod = 90
  SET @Existe_Tag_Prod = 0 
  
  SET @e_Tag_Prod_Familias = 80
  SET @Existe_Tag_Fam = 0 
 
  SET @e_Tag_Prod_Cajas = 250
  SET @Existe_Tag_Caja = 0


  IF @pRegenerar_Archivo = 'S'
     BEGIN
        DELETE RPT_Productos_Cob_Detalle where Fecha_Rec >= @pFechaDesde  and Fecha_Rec < dateadd(dd,1,@pFechaHasta)
        SELECT * INTO #REPORTE FROM RPT_Productos_Cob_Detalle where 0=1
		DELETE #REPORTE

		/************************************************************* Creo las tablas ***************************************************************************************/
		------------- calculo importe cancelado por recibo

		SELECT A.ID_TRANS_D,SUM(A.IMPORTE) AS IMPORTE_REC
		   INTO #TOT_RECIBOS
		   FROM  CBTES C, CBTES_TIPOS T, CBTES_APLICA A
		   WHERE C.Id_Tipo_Cbte = T.Id_Tipo_Cbte
				 AND  T.Compromete_Recibos IN (1,-1)
				 AND A.ID_TRANS_D = C.ID_TRANS
				 AND C.ID_ESTADO_CBTE not in (0,3)
				 AND C.FECHA >= @pFechaDesde 
				 AND C.FECHA < dateadd(dd,1,@pFechaHasta)
				 AND A.IMPORTE > 0
				 GROUP BY A.ID_TRANS_D 

		 SELECT C.ID_TRANS, C.FECHA, TR.IMPORTE_REC AS IMP_TOTAL,V.ID_TIPO_VAL,V.IMPORTE,CAST(V.Importe /TR.IMPORTE_REC AS DECIMAL(16,8)) AS COEF
		   INTO #VALORES_REC
		   FROM CBTES C, CBTES_TIPOS T, VALORES V, VALORES_MOV M, #TOT_RECIBOS TR
		   WHERE C.Id_Tipo_Cbte = T.Id_Tipo_Cbte
				 AND ((T.COMPROMETE_FACTURA  = 1 AND C.Id_Cond_Pago = 1)
				 OR T.Compromete_Recibos IN (1,-1))
				 AND C.ID_TRANS = TR.ID_TRANS_D
				 AND C.ID_TRANS = M.ID_TRANS
				 AND M.ID_VALOR = V.ID_VALOR
				 AND M.Renglon_Nro = 1
				 AND C.ID_ESTADO_CBTE NOT IN (0,3)
				 AND C.FECHA >= @pFechaDesde 
				 AND C.FECHA < dateadd(dd,1,@pFechaHasta)

		 
		SELECT C.ID_TRANS,C.FECHA,TR.IMPORTE_REC AS IMP_TOTAL,'ACUENTA' AS ID_PRODUCTO ,A.IMPORTE AS IMPORTE, CAST(A.IMPORTE/TR.IMPORTE_REC AS DECIMAL(16,8)) AS COEF,C.ID_CLIENTE 
		   INTO #ACUENTA
		   FROM CBTES C, CBTES_TIPOS T, CBTES_APLICA A, #TOT_RECIBOS TR
			 WHERE C.Id_Tipo_Cbte = T.Id_Tipo_Cbte
				 AND  T.Compromete_Recibos IN (1,-1)
				 AND A.ID_TRANS_D = C.ID_TRANS
				 AND C.ID_TRANS = TR.ID_TRANS_D
				 AND A.Id_Trans = 0
				 AND C.ID_ESTADO_CBTE NOT IN (0,3)
				 AND C.FECHA >= @pFechaDesde 
				 AND C.FECHA < dateadd(dd,1,@pFechaHasta)
				 AND A.IMPORTE <> 0
 

		   Declare @Pagos_a_Cuenta DECIMAL(14,2)
		   SET @Pagos_a_Cuenta = ISNULL((select sum(IMPORTE) FROM #ACUENTA WHERE IMPORTE > 0 ),0)

		-----aplicaciones

		SELECT C.ID_TRANS,C.FECHA,TR.IMPORTE_REC AS IMP_TOTAL,'APL' AS ID_TIPO_VAL,SUM(A.IMPORTE)*-1 AS IMPORTE, CAST(0 AS DECIMAL(16,8)) AS COEF
		   INTO #RECIBOS_APLIC
		   FROM CBTES C, CBTES_TIPOS T, CBTES_APLICA A , CBTES_TIPOS TNC, CBTES REC ,#TOT_RECIBOS TR
		   WHERE C.Id_Tipo_Cbte = T.Id_Tipo_Cbte
				 AND  T.Compromete_Recibos IN (1,-1)
				 AND A.ID_TRANS_D = C.ID_TRANS
				 AND C.ID_TRANS = TR.ID_TRANS_D
				 AND REC.Id_Trans = A.ID_TRANS
				 AND REC.Id_Tipo_Cbte = TNC.Id_Tipo_Cbte
				 AND TNC.COMPROMETE_RECIBOS = 1
				 AND C.ID_ESTADO_CBTE <> 3
				 AND C.FECHA >= @pFechaDesde 
				 AND C.FECHA < dateadd(dd,1,@pFechaHasta)
				 AND A.IMPORTE <> 0
				 GROUP BY C.ID_TRANS,C.FECHA,TR.IMPORTE_REC

		-----------N/C
 
		SELECT C.ID_TRANS, C.FECHA,R.IMPORTE_REC AS IMP_TOTAL,'N/C' AS ID_TIPO_VAL,SUM(A.IMPORTE)*-1 AS IMPORTE, CAST(0 AS DECIMAL(16,8)) AS COEF 
		   INTO #NCREDITO
		   FROM CBTES C, CBTES_TIPOS T, CBTES_APLICA A, CBTES NC, CBTES_TIPOS TNC, #TOT_RECIBOS R
		   WHERE C.Id_Tipo_Cbte = T.Id_Tipo_Cbte
				 AND  T.Compromete_Recibos IN (1,-1)
				 AND A.ID_TRANS_D = C.ID_TRANS
				 AND A.ID_TRANS_D = R.ID_TRANS_D
				 AND A.Id_Trans = NC.ID_TRANS
				 AND NC.Id_Tipo_Cbte = TNC.Id_Tipo_Cbte
				 AND (TNC.COMPROMETE_FACTURA = -1)
				 AND C.ID_ESTADO_CBTE <> 3
				 AND C.FECHA >= @pFechaDesde 
				 AND C.FECHA < dateadd(dd,1,@pFechaHasta)
				 AND A.IMPORTE <> 0
				 GROUP BY C.ID_TRANS, C.FECHA ,R.IMPORTE_REC

		SELECT R.Id_Trans,SUM(R.IMPORTE) AS IMPORTE_RETEN
		   INTO #TOT_RETEN 
		   FROM  CBTES_RETEN R, #TOT_RECIBOS A
		   WHERE R.Id_Trans = A.Id_Trans_D
				 AND R.IMPORTE > 0
				 GROUP BY R.Id_Trans

		SELECT C.ID_TRANS, C.FECHA, R.IMPORTE_REC AS IMP_TOTAL,'RET' AS ID_TIPO_VAL,T.IMPORTE_RETEN AS IMPORTE, CAST(0 AS DECIMAL(16,8)) AS COEF 
		   INTO #RETEN
		   FROM CBTES C, #TOT_RETEN T, #TOT_RECIBOS R
		   WHERE C.ID_TRANS  = T.ID_TRANS
				 AND R.ID_TRANS_D = C.ID_TRANS 
				 AND T.IMPORTE_RETEN <> 0
  
 
		  INSERT INTO #VALORES_REC
				  SELECT * FROM #NCREDITO
		  INSERT INTO #VALORES_REC
				  SELECT * FROM #RECIBOS_APLIC
		  INSERT INTO #VALORES_REC
				  SELECT * FROM #RETEN

		  UPDATE #VALORES_REC SET COEF = IMPORTE/IMP_TOTAL  FROM #VALORES_REC  

		--- FACTURAS CANCELADAS

		SELECT C.ID_TRANS,R.IMPORTE_REC AS IMP_TOTAL,F.ID_TRANS AS ID_TRANS_FAC, A.IMPORTE 
		, CAST((abs(A.IMPORTE)/R.IMPORTE_REC) AS DECIMAL(16,8)) AS COEF, C.Porc_Bonificacion
		   INTO #FACTURAS
		   FROM CBTES C, CBTES_TIPOS T, CBTES_APLICA A, CBTES F, CBTES_TIPOS TF, #TOT_RECIBOS R
		   WHERE C.Id_Tipo_Cbte = T.Id_Tipo_Cbte
				 AND T.Compromete_Recibos IN (1,-1)
				 AND A.ID_TRANS_D = C.ID_TRANS
				 AND A.Id_Trans = F.ID_TRANS
				 AND A.ID_TRANS_D = R.ID_TRANS_D
				 AND F.Id_Tipo_Cbte = TF.Id_Tipo_Cbte
				 AND (TF.COMPROMETE_FACTURA in (1))
				 AND C.ID_ESTADO_CBTE <> 3
				 AND C.FECHA >= @pFechaDesde 
				 AND C.FECHA < dateadd(dd,1,@pFechaHasta)
				 AND A.IMPORTE <> 0
			     AND R.IMPORTE_REC <> 0

		--		 ITEMS DE LAS FACTURAS CANCELADAS

		   SELECT I.ID_TRANS as Id_TRans_Fac,I.ITEM,ID_CLIENTE,I.ID_PRODUCTO,Descripcion_producto,CAST(I.Imp_Final*(1-F.Porc_Bonificacion/100) AS DECIMAL(12,2)) AS IMP_FINAL_PRODUCTO ,
				f.coef,
				CAST((i.Imp_Final* (1-F.Porc_Bonificacion/100) * f.coef) AS DECIMAL(12,2)) AS Imp_Cobrado
				,F.Id_Trans
				,F.Importe AS iMPORTE
				into #items
				FROM CBTES_ITEMS I, #FACTURAS F
				WHERE I.ID_TRANS = F.ID_TRANS_FAC
				AND I.Imp_Final <> 0
	--			ORDER BY I.ID_TRANS

		-- AGREGO PAGOS A CUENTAS
		   insert into  #items SELECT 0,0,A.ID_CLIENTE,'ACUENTA','PAGO A CUENTA',A.IMPORTE,A.COEF,A.IMPORTE,A.ID_TRANS,A.IMPORTE
				 FROM #ACUENTA A


		   SELECT I.ID_TRANS,I.ITEM,i.ID_CLIENTE,i.ID_PRODUCTO,i.Descripcion_producto,i.IMP_FINAL_PRODUCTO ,
				cast(i.coef * 100 as DECIMAL(7,2))  AS Porc_Cobr_Fact,
				i.Imp_Cobrado,
				R.Id_Tipo_Val,
				cast(R.coef * 100 as DECIMAL(7,2)) AS Porc_TVal,
				CAST(i.Imp_Cobrado*r.coef AS DECIMAL(12,2)) AS IMP_VALOR
				,I.Id_Trans_Fac
				,R.FECHA
				,R.IMP_TOTAL
				,i.Coef 
				,I.Importe
				INTO #RESUMEN 
				FROM #items i, #VALORES_REC R
				WHERE I.ID_TRANS = r.ID_TRANS
				AND I.Imp_Cobrado <> 0
				ORDER BY I.ID_TRANS 

		  INSERT INTO #REPORTE
				 SELECT  cast((i.Imp_Gravado * CF.Cotizacion) as decimal(14,2)) as Imp_Gravado_Item				--1
					,cast((i.Imp_Final * CF.Cotizacion) as decimal(14,2)) as Imp_Final_Item								--2
					,R.ID_TRANS_FAC as Id_Trans_Fac																		--3
					,cast((Cf.Imp_Gravado + CF.Imp_Gravado2 + Cf.Imp_Gravado3 + Cf.Imp_Exento) * CF.Cotizacion as decimal(14,2)) as Importe_Fac		--4
					,cast(Cf.Imp_total * CF.Cotizacion  as decimal(14,2)) as Imp_total_Fac							    --5
					,R.Id_trans as Id_Trans_Rec																			--6
					,cast(R.IMP_VALOR  as decimal(14,2))  as Importe_Aplicado											--7
					,i.Fecha_QA																							--8
					,i.Fecha_Venc																						--9
					,C.Id_cliente																						--10
					,C.Nombre_Fantasia																					--11
					,C.Id_Cliente_Externo																				--12
					,C.Razon_Social																						--13
					,C.Id_Tipo_Cli																						--14
					,dbo.CF_Cbte_Descrip(R.ID_TRANS_FAC) as Desc_Factura												--15
					,CR.Fecha																							--16
					,dbo.CF_Cbte_Descrip(R.ID_TRANS) as Desc_Recibo														--17
					,R.Fecha as Fecha_Rec																				--18
					,cast(R.IMP_TOTAL as decimal(14,2)) as Imp_Total_Rec												--19
					,CR.Id_Estado_Cbte																					--20
					,CR.Cotizacion as Cotizacion_Rec																	--21
					,CF.Cotizacion as Cotizacion_Fac																	--22
     				,CF.Porc_Bonificacion																				--23
					,CR.Id_Cobrador																						--24
					,R.Id_Producto																						--25
					,P.Descripcion_Detallada																			--26
					,P.Id_Familia																						--27
					,ISNULL(FP.Descripcion,'Pagos a Cuenta') as Descripcion_Familia										--28
 					,R.COEF * 100 as porc_aplicado																		--29
					,CAST(IMP_VALOR AS DECIMAL(12,2))  as Imp_Prod_CIva													--30
					,CAST(IMP_VALOR AS DECIMAL(12,2))  AS Imp_Prod_SIva												    --31
					,VE.DESCRIPCION AS Nombre_Cobrador																	--32
					,dbo.SF_Cli_Categ_Mes(i.Id_cliente, isnull(i.Fecha_QA,CR.Fecha)) as Id_Tipo_Cli_Ori					--33
					,CT.Descripcion AS Descripcion_Tipo_Cli																--34
					,isnull(c.id_cliente_ref,0) as id_cliente_ref														--35
					,cast(0 as decimal(14,2)) AS EFECTIVO																--36
					,cast(0 as decimal(14,2)) AS TARJETA																--37
					,cast(0 as decimal(14,2)) AS CHEQ_TER																--38
					,cast(0 as decimal(14,2)) AS CHEQ_PROP																--39
					,cast(0 as decimal(14,2)) AS DEBITO																	--40
					,cast(0 as decimal(14,2)) AS FINANC																	--41
					,cast(0 as decimal(14,2)) AS OTROS																	--42
					,cast(0 as decimal(14,2)) AS APLIC																	--43
					,CAST(IMP_VALOR AS DECIMAL(12,2)) AS Total_Pagos													--44
					,cast(0 as decimal(14,2)) AS Dif																	--45
					,i.Item as Item_Fac																					--46
 					,cast(R.coef as decimal(12,5)) AS Coef_Pago															--47 
					,ISNULL(CF.Id_Cond_Pago, 0) AS Id_Cond_Pago															--48  
					,ISNULL(CCP.Descripcion, '') AS Cond_Pago															--49  
					,cast(CF.Imp_Percep as decimal(14,2)) AS Imp_Total_Percep_Reten_Fac									--50  
					,cast(CR.Imp_Percep as decimal(14,2)) AS Imp_Total_Percep_Reten_Rec									--51  
					,CLFC.Nombre_Fantasia		AS FC_CL_Nombre_Fantasia												--52 
					,CLFC.Id_Cliente_Externo	AS FC_CL_Id_Cliente_Externo												--53 
					,CLFC.Razon_Social			AS FC_CL_Razon_Social													--54 
					,CLFC.Id_Tipo_Cli			AS FC_CL_Id_Tipo_Cli													--55 
					,CR.Id_Cobrador				AS CL_Id_Cobrador														--56 
					,CP.Id_Caja					AS Id_Caja																--57 
					,cast(I.Bonif as decimal(14,2)) AS Porc_Bonif_Item													--58 
					,cast(((100 * I.Imp_Final) / (100-I.Bonif) * (R.Porc_Tval/100 )) as decimal(14,2)) AS Imp_Final_Item_Sin_Desc	--59 
					,cast(((100 * I.Imp_Final) * (I.Bonif/100) * (R.Porc_Tval/100)) as decimal(14,2)) AS Imp_Bonif_Item				--60 
					,cast(0 as decimal(14,2)) AS Cantidad_Prod															--61
					,P.Id_Alias_Cta_Cont AS Alias																		--62
					,P.Id_Centro_Costo   																		     	--63 
					,CONVERT(VARCHAR(20), TRR.Fecha_Mov, 120) AS Fac_Fecha_Mov											--64 
					,CONVERT(VARCHAR(20), TRF.Fecha_Mov, 120) AS Rec_Fecha_Mov                                          --65 
    				,cast(R.Importe as decimal(14,2)) As Importe                                                        --66 
 					,CM.Id_Periodo_Caja      AS Id_Periodo_Caja                                                         --67 
					,CR.id_tipo_Cbte         AS Id_Tipo_Cbte_Fac                                                        --68 
					,TF.Descripcion          AS Descripcion_Fac --69
					,I.Imp_Final --70
					,R.coef      --71
					,R.Id_Tipo_Val  --72
					, (R.Porc_Tval/100) AS COEF_VAL  --73
					,cast(0 as decimal(14,2)) AS Ajustes	--74  												 
					,cast(0 as decimal(14,2)) AS Acuenta    --75
					,I.ITEM  --76
			  FROM #RESUMEN R 
					LEFT JOIN Cbtes CR  ON R.ID_TRANS = CR.ID_TRANS                         ---ojjo
					LEFT JOIN Cbtes_Tipos TF ON CR.Id_Tipo_Cbte = TF.Id_Tipo_Cbte
					LEFT JOIN Transacciones TRF ON TRF.ID_TRANS = CR.ID_TRANS
					LEFT JOIN Clientes CLFC ON CR.Id_Cliente = CLFC.Id_Cliente
					LEFT JOIN Clientes_Tipos CT ON CLFC.Id_Tipo_Cli = CT.Id_Tipo_Cli
					LEFT JOIN Vendedores VE ON CR.Id_Cobrador = VE.Id_Vendedor
					LEFT JOIN CBTES_ITEMS I ON I.ID_TRANS = R.ID_TRANS_FAC AND I.ITEM = R.ITEM
					LEFT JOIN PRODUCTOS P ON R.ID_PRODUCTO  = P.ID_PRODUCTO
					LEFT JOIN PROD_FAMILIAS FP ON P.ID_FAMILIA  = FP.ID_FAMILIA
					LEFT JOIN CLIENTES C ON R.ID_CLIENTE  = C.ID_CLIENTE
					LEFT JOIN CBTES CF ON  CF.ID_TRANS  = R.ID_TRANS_FAC
					LEFT JOIN CBTES_COND_PAGO CCP ON CF.Id_Cond_Pago = CCP.Id_Cond_Pago
		  			LEFT JOIN Transacciones TRR ON TRR.ID_TRANS = R.ID_TRANS_FAC
					LEFT JOIN CAJAS_MOV CM ON CM.Id_Trans = R.Id_Trans
					LEFT JOIN CAJAS_PERIODOS CP ON CP.Id_Periodo_Caja = CM.Id_Periodo_Caja


		UPDATE #Reporte SET EFECTIVO = Imp_Prod_CIva FROM #Reporte WHERE Id_Tipo_Val = 'EFE' 
		UPDATE #Reporte SET TARJETA  = Imp_Prod_CIva FROM #Reporte WHERE Id_Tipo_Val = 'TAR'  
		UPDATE #Reporte SET CHEQ_TER = Imp_Prod_CIva FROM #Reporte WHERE Id_Tipo_Val = 'CH3'
		UPDATE #Reporte SET Cheq_Prop = Imp_Prod_CIva FROM #Reporte WHERE Id_Tipo_Val = 'CHP'  
		UPDATE #Reporte SET DEBITO = Imp_Prod_CIva FROM #Reporte WHERE Id_Tipo_Val = 'DB'  
		UPDATE #Reporte SET FINANC = Imp_Prod_CIva FROM #Reporte WHERE Id_Tipo_Val = 'FIN'
		UPDATE #Reporte SET APLIC = Imp_Prod_CIva FROM #Reporte WHERE Id_Tipo_Val IN ('APL','N/C')
		UPDATE #Reporte SET AJUSTES = isnull(Imp_Prod_CIva,0) FROM #Reporte WHERE Id_Tipo_Val = 'AJU' 
		UPDATE #Reporte SET ACUENTA = Imp_Prod_CIva FROM #Reporte WHERE Id_PRODUCTO = 'ACUENTA'
		UPDATE #Reporte SET OTROS = Imp_Prod_CIva FROM #Reporte WHERE Id_Tipo_Val = ('RET')
		UPDATE #Reporte SET Total_Pagos = (Efectivo+Tarjeta+Cheq_Ter+Cheq_Prop+Debito+Financ+Ajustes+APLIC+OTROS) from #REPORTE

	    UPDATE #Reporte SET Id_Centro_Costo = '' WHERE Id_Centro_Costo IS NULL 

      IF @pRegenerar_Archivo = 'S'
	     INSERT INTO RPT_Productos_Cob_Detalle 
		        SELECT * FROM #Reporte

 END

  /************************************************************* Resultado ***************************************************************************************/


  ----VALIDAR FILTROS

  IF @pFlag_Filtrar_Prod = 1
	SET @Existe_Tag_Prod = ISNULL( (SELECT COUNT(*) FROM TagFilePos_ TAG WHERE TAG.TBL = @e_Tag_Prod AND TAG.USR = @pId_Usuario) ,0)
  
  IF @pFlag_Filtrar_Fam = 1
	 SET @Existe_Tag_Fam = ISNULL( (SELECT COUNT(*) FROM TagFile_ TAG WHERE TAG.TBL = @e_Tag_Prod_Familias AND TAG.USR = @pId_Usuario) ,0)


  SELECT * INTO #PRODUCTOS FROM PRODUCTOS
  IF @Existe_Tag_Prod > 0 and @pFlag_Filtrar_Prod = 1
        DELETE #PRODUCTOS FROM #PRODUCTOS P WHERE P.ID_PRODUCTO NOT IN (SELECT Tag.Pos FROM TagFilePos_ TAG WHERE  TAG.TBL = @e_Tag_Prod AND TAG.USR = @pId_Usuario )

  SELECT * INTO #FAMILIAS FROM PROD_FAMILIAS
  IF @Existe_Tag_Fam > 0 and @pFlag_Filtrar_Fam = 1
        DELETE #FAMILIAS FROM #FAMILIAS P WHERE P.Id_Familia NOT IN (SELECT Tag.Val FROM TagFile_ TAG WHERE  TAG.TBL = @e_Tag_Prod_Familias AND TAG.USR = @pId_Usuario )

  SELECT * INTO #CAJAS_PERIODOS FROM Cajas_Periodos
   IF @pFlag_Filtrar_Caja = 1 
        DELETE #CAJAS_PERIODOS FROM #CAJAS_PERIODOS P WHERE P.Id_Periodo_Caja NOT IN (SELECT Tag.Val FROM TagFile_ TAG WHERE  TAG.TBL = @e_Tag_Prod_Cajas AND TAG.USR = @pId_Usuario )
 
---------------
  set @Total = (SELECT SUM(ISNULL(Imp_Prod_CIva,0)) FROM RPT_Productos_Cob_Detalle)
  
  IF UPPER(@pFormato) = 'D' OR @pFormato = ''
		    SELECT R.*,P.Descripcion AS Cta, P.Nro_Cta_Contable, CC.Descripcion AS Centro_Costo, C.Telefono, C.Email
				FROM RPT_Productos_Cob_Detalle R 
				 INNER JOIN Pla_Ctas_Cuentas_Contables P ON P.Id_Cta_Contable = dbo.CF_Cta_Cont(R.Alias,R.Fecha_Rec)
		    	 INNER JOIN #PRODUCTOS PR ON PR.ID_PRODUCTO  = R.ID_PRODUCTO
                 INNER JOIN #FAMILIAS FP ON FP.ID_FAMILIA  = R.ID_FAMILIA
				 INNER JOIN #CAJAS_PERIODOS CP ON CP.Id_Periodo_Caja = R.Id_Periodo_Caja
				 INNER JOIN CLIENTES C ON C.Id_Cliente = R.Id_cliente
				, Centro_Costos CC
				WHERE R.Id_Centro_Costo = CC.Id_Centro_Costo 
					  AND R.FECHA_REC >= @pFechaDesde 
			          AND R.FECHA_REC < dateadd(dd,1,@pFechaHasta)
				ORDER BY R.Id_Producto,R.Fecha_Rec,R.Desc_Recibo

  IF UPPER(@pFormato) = 'P'
     SELECT R.Id_Producto,R.Descripcion_Detallada, SUM(r.Imp_Prod_CIva) AS Imp_Prod_CIva,
	        cast((SUM(R.Imp_Prod_CIva) / @Total * 100 ) as decimal(16,2)) AS Participacion 
			FROM RPT_Productos_Cob_Detalle R
				 INNER JOIN #PRODUCTOS PR ON PR.ID_PRODUCTO  = R.ID_PRODUCTO
                 INNER JOIN #FAMILIAS FP ON FP.ID_FAMILIA  = R.ID_FAMILIA
				 INNER JOIN #CAJAS_PERIODOS CP ON CP.Id_Periodo_Caja = R.Id_Periodo_Caja
		    WHERE R.FECHA_REC >= @pFechaDesde 
				  AND R.FECHA_REC < dateadd(dd,1,@pFechaHasta)
			GROUP BY R.Id_Producto, R.Descripcion_Detallada
			ORDER BY Participacion Desc,R.Descripcion_Detallada  

  IF UPPER(@pFormato) = 'F'
     SELECT R.Id_Familia, R.Descripcion_Familia, SUM(Imp_Prod_CIva) AS Imp_Prod_CIva,
	        CONVERT(DECIMAL(8,2),SUM(Imp_Prod_CIva) / @Total * 100) AS Participacion
			FROM RPT_Productos_Cob_Detalle R
				 INNER JOIN #PRODUCTOS PR ON PR.ID_PRODUCTO  = R.ID_PRODUCTO
                 INNER JOIN #FAMILIAS FP ON FP.ID_FAMILIA  = R.ID_FAMILIA
				 INNER JOIN #CAJAS_PERIODOS CP ON CP.Id_Periodo_Caja = R.Id_Periodo_Caja
			Where R.Id_Familia > 0
				AND R.FECHA_REC >= @pFechaDesde 
				AND R.FECHA_REC < dateadd(dd,1,@pFechaHasta)
			GROUP BY R.Id_Familia, R.Descripcion_Familia
			ORDER BY Participacion Desc


  IF UPPER(@pFormato) = 'CF'
	 SELECT R.Id_Familia, R.Descripcion_Familia,R.Id_Cobrador,R.Nombre_Cobrador , SUM(Imp_Prod_CIva) AS Imp_Prod_CIva, 
	        CONVERT(DECIMAL(8,2),SUM(Imp_Prod_CIva) / @Total * 100) AS Participacion
			FROM RPT_Productos_Cob_Detalle R 
				 INNER JOIN #PRODUCTOS PR ON PR.ID_PRODUCTO  = R.ID_PRODUCTO
                 INNER JOIN #FAMILIAS FP ON FP.ID_FAMILIA  = R.ID_FAMILIA
				 INNER JOIN #CAJAS_PERIODOS CP ON CP.Id_Periodo_Caja = R.Id_Periodo_Caja
			Where R.Id_Familia > 0
				AND R.FECHA_REC >= @pFechaDesde 
				AND R.FECHA_REC < dateadd(dd,1,@pFechaHasta)
			GROUP BY R.Id_Familia, R.Descripcion_Familia,R.Id_Cobrador,R.Nombre_Cobrador
			ORDER BY R.Nombre_Cobrador,Participacion Desc

  IF UPPER(@pFormato) = 'CFM'
	 SELECT R.Id_Familia, R.Descripcion_Familia,R.Id_Cobrador,R.Nombre_Cobrador , 
			DATEPART(mm,R.Fecha_QA) AS Mes,DATEPART(YY,R.Fecha_QA) AS Anio,
			SUM(Imp_Prod_CIva) AS Imp_Prod_CIva, 
	        CONVERT(DECIMAL(8,2),SUM(Imp_Prod_CIva) / @Total * 100) AS Participacion
			FROM RPT_Productos_Cob_Detalle R 
				 INNER JOIN #PRODUCTOS PR ON PR.ID_PRODUCTO  = R.ID_PRODUCTO
                 INNER JOIN #FAMILIAS FP ON FP.ID_FAMILIA  = R.ID_FAMILIA
				 INNER JOIN #CAJAS_PERIODOS CP ON CP.Id_Periodo_Caja = R.Id_Periodo_Caja
			Where R.Id_Familia > 0
				AND R.FECHA_REC >= @pFechaDesde 
				AND R.FECHA_REC < dateadd(dd,1,@pFechaHasta)
			GROUP BY R.Id_Familia, R.Descripcion_Familia,R.Id_Cobrador,R.Nombre_Cobrador,DATEPART(mm,R.Fecha_QA),DATEPART(YY,R.Fecha_QA)
			ORDER BY R.Nombre_Cobrador,R.Id_Cobrador,R.Descripcion_Familia,DATEPART(YY,R.Fecha_QA),DATEPART(mm,R.Fecha_QA)


  IF UPPER(@pFormato) = 'T'
	 SELECT Id_Tipo_Cli_Ori, T.Descripcion  , SUM(Imp_Prod_CIva) AS Imp_Prod_CIva, 
	        CONVERT(DECIMAL(8,2),SUM(Imp_Prod_CIva) / @Total * 100) AS Participacion
			FROM RPT_Productos_Cob_Detalle R
				 INNER JOIN #PRODUCTOS PR ON PR.ID_PRODUCTO  = R.ID_PRODUCTO
                 INNER JOIN #FAMILIAS FP ON FP.ID_FAMILIA  = R.ID_FAMILIA
				 INNER JOIN #CAJAS_PERIODOS CP ON CP.Id_Periodo_Caja = R.Id_Periodo_Caja, Clientes_Tipos t
			WHERE T.Id_Tipo_Cli = R.Id_Tipo_Cli_Ori
				AND R.FECHA_REC >= @pFechaDesde 
				AND R.FECHA_REC < dateadd(dd,1,@pFechaHasta)
			GROUP BY Id_Tipo_Cli_Ori, T.Descripcion 
			ORDER BY Participacion Desc

  IF UPPER(@pFormato) = 'FP'
   
	 SELECT substring(convert(nvarchar(10),Fecha_Rec,112),1,6)+'01' as Fecha_Rec,sum(Efectivo) as Efectivo,sum(Tarjeta) as Tarjeta 
	        ,sum(Cheq_ter) as Cheq_ter,sum(CHEQ_PROP) as Cheq_Prop ,sum(DEBITO) as Debito 
			,sum(FINANC) as Financ ,sum(OTROS) as Otros,sum(AJUSTES) as Ajustes,sum(APLIC) as Aplic,sum(ACUENTA) as Acuenta, sum(Total_Pagos) as Total_Pagos
	 		FROM RPT_Productos_Cob_Detalle R
			   	 INNER JOIN #PRODUCTOS PR ON PR.ID_PRODUCTO  = R.ID_PRODUCTO
                 INNER JOIN #FAMILIAS FP ON FP.ID_FAMILIA  = R.ID_FAMILIA
				 INNER JOIN #CAJAS_PERIODOS CP ON CP.Id_Periodo_Caja = R.Id_Periodo_Caja
				 WHERE R.FECHA_REC >= @pFechaDesde 
				 AND R.FECHA_REC < dateadd(dd,1,@pFechaHasta)
			GROUP BY substring(convert(nvarchar(10),Fecha_Rec,112),1,6)+'01'



  IF UPPER(@pFormato) = 'CTA'
     BEGIN
		 SELECT R.Alias,C.Nro_Cta_Contable,C.Descripcion ,R.Id_Centro_Costo,CC.Descripcion AS Centro_Costo,SUM(Imp_Prod_CIva) AS Imp_Prod_CIva, 
				CONVERT(DECIMAL(8,2),SUM(Imp_Prod_CIva) / @Total * 100) AS Participacion 
				FROM RPT_Productos_Cob_Detalle R 
				 INNER JOIN #PRODUCTOS PR ON PR.ID_PRODUCTO  = R.ID_PRODUCTO
                 INNER JOIN #FAMILIAS FP ON FP.ID_FAMILIA  = R.ID_FAMILIA
				 INNER JOIN #CAJAS_PERIODOS CP ON CP.Id_Periodo_Caja = R.Id_Periodo_Caja
				 , Pla_Ctas_Cuentas_Contables C, Centro_Costos CC
				WHERE  C.Id_Cta_Contable = dbo.CF_Cta_Cont(R.Alias,R.Fecha_Rec)
				AND R.Id_Centro_Costo = CC.Id_Centro_Costo
				AND R.FECHA_REC >= @pFechaDesde 
				AND R.FECHA_REC < dateadd(dd,1,@pFechaHasta)
				GROUP BY R.Alias,C.Nro_Cta_Contable,C.Descripcion ,R.Id_Centro_Costo,CC.Descripcion
				ORDER BY C.Nro_Cta_Contable,R.Id_Centro_Costo
     END


  IF UPPER(@pFormato) = 'CC'
     BEGIN
		 SELECT R.Id_Centro_Costo,CC.Descripcion AS Centro_Costo,SUM(Imp_Prod_CIva) AS Imp_Prod_CIva, 
				CONVERT(DECIMAL(8,2),SUM(Imp_Prod_CIva) / @Total * 100) AS Participacion 
				FROM RPT_Productos_Cob_Detalle R 
				 INNER JOIN #PRODUCTOS PR ON PR.ID_PRODUCTO  = R.ID_PRODUCTO
                 INNER JOIN #FAMILIAS FP ON FP.ID_FAMILIA  = R.ID_FAMILIA
				 INNER JOIN #CAJAS_PERIODOS CP ON CP.Id_Periodo_Caja = R.Id_Periodo_Caja
				, Pla_Ctas_Cuentas_Contables C, Centro_Costos CC
				WHERE  C.Id_Cta_Contable = dbo.CF_Cta_Cont(R.Alias,R.Fecha_Rec)
				AND R.Id_Centro_Costo = CC.Id_Centro_Costo
				AND R.FECHA_REC >= @pFechaDesde 
				AND R.FECHA_REC < dateadd(dd,1,@pFechaHasta)
				GROUP BY R.Id_Centro_Costo,CC.Descripcion
				ORDER BY CC.Descripcion
      END

 
  IF EXISTS(SELECT [name] FROM tempdb.sys.tables WHERE [name] = '#Reporte') 
		DROP TABLE #Reporte

  IF @pRegenerar_Archivo ='S'
     BEGIN
		  DROP TABLE #NCREDITO
		  DROP TABLE #VALORES_REC
		  DROP TABLE #FACTURAS
		  DROP TABLE #RESUMEN 
		  DROP TABLE #ITEMS
		  DROP TABLE #RECIBOS_APLIC
		  DROP TABLE #PRODUCTOS  
		  DROP TABLE #FAMILIAS 
		  DROP TABLE #CAJAS_PERIODOS  
		  DROP TABLE #RETEN 
		  DROP TABLE #TOT_RETEN 		
     END


/*

EXEC CPJ_Productos_Cobros '{"Id_Usuario":"-1"
,"Equate":"90"
,"FechaDesde":"20220701"
,"FechaHasta":"20220704"
,"Flag_Liquidacion":"2"
,"Flag_FPago":"0"
,"Tipo_Cob":"-"
,"Formato":"F"
,"Flag_Filtrar_Prod":"0"
,"Flag_Filtrar_Fam":"0"
,"Flag_Filtrar_Caja":"0"
,"Regenerar_Archivo":"n"
,"Flag_Inc_Fact_Periodo":"0"}' 


select * from TagFilePos_

delete TagFilePos_ where usr =-1

select * from RPT_Productos_Cob_Detalle


*/


